<?php

namespace WPStaging\Pro;

use WPStaging\Core\WPStaging;
use WPStaging\Framework\DI\Container;
use WPStaging\Framework\DI\ServiceProvider;
use WPStaging\Framework\Notices\Notices as NoticesBase;
use WPStaging\Framework\SiteInfo;
use WPStaging\Pro\Backup\BackupServiceProvider;
use WPStaging\Pro\License\LicenseServiceProvider;
use WPStaging\Pro\Push\PushServiceProvider;
use WPStaging\Pro\Notices\Notices;
use WPStaging\Pro\Staging\StagingSiteServiceProvider;
use WPStaging\Pro\Template\TemplateServiceProvider;
use WPStaging\Pro\Auth\AuthServiceProvider;
use WPStaging\Pro\WpCli\WpCliServiceProvider;
use WPStaging\Pro\Activate\PluginActivationServiceProvider;
use WPStaging\Pro\Staging\StagingServiceProvider;

class ProServiceProvider extends ServiceProvider
{
    /** @var Container $container */
    protected $container;

    protected function registerClasses()
    {
        // This is to tell the container to use the PRO feature
        $this->container->setVar('WPSTG_PRO', true);
        $this->container->register(BackupServiceProvider::class);

        if (defined('WPSTG_REQUIRE_FREE') && WPSTG_REQUIRE_FREE) {
            $this->container->register(PluginActivationServiceProvider::class);

            if (!wpstgIsFreeActiveInNetworkOrCurrentSite()) {
                return;
            }
        }

        $this->container->register(TemplateServiceProvider::class);
        $this->container->register(LicenseServiceProvider::class);
        $this->container->register(AuthServiceProvider::class);

        if ($this->container->get(SiteInfo::class)->isStagingSite()) {
            $this->container->register(StagingSiteServiceProvider::class);
        }

        $this->container->register(StagingServiceProvider::class);
        $this->container->register(PushServiceProvider::class);

        // Feature providers.
        $this->container->register(WpCliServiceProvider::class);
    }

    protected function addHooks()
    {
        add_action(NoticesBase::PRO_NOTICES_ACTION, $this->container->callback(Notices::class, 'renderNotices')); // phpcs:ignore WPStaging.Security.FirstArgNotAString
    }
}
